/*******************************************************************************

   Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

 *******************************************************************************

   $Id:: DevNetAp_Public.h 54059 2015-05-21 13:43:43Z trieu                    $

   Description:
    ............................................................................

    Includes following functions:

   Changes:

     Version     Date        Author
     X.X.X.X   DD.MM.JJJJ  Mustermann
     Description................................................................
     ---------------------------------------------------------------------------

******************************************************************************/

/**
 * @file DevNetAp_Public.h
 *  DevNet Ap - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 * 
 * @note
 * The structures for the services must be packed on 1 byte of boundary.
 * The <code>#pragma</code> instructions are already planned for Microsoft compiler.
 * For gnu's compiler and Realview compiler the macros <code>__PACKED_PRE</code>
 * and <code>__PACKED_PRE</code> have to be added with the structural definition
 * in addition.
 */
#ifndef __DEVNET_AP_PUBLIC_H
#define __DEVNET_AP_PUBLIC_H


#include "DevNetFal_Public.h"


/******************************************************************************/
/* Command definition */
#define DEVNET_AP_CMD_START               0x00003900
#define DEVNET_AP_CMD_IO_SCAN_REQ         0x00003900
#define DEVNET_AP_CMD_IO_SCAN_CNF         0x00003901
//#define DEVNET_AP_CMD_WATCHDOG_IND        0x00003902
//#define DEVNET_AP_CMD_WATCHDOG_RSP        0x00003903
#define DEVNET_AP_CMD_GET_LED_STATE_REQ   0x00003904
#define DEVNET_AP_CMD_GET_LED_STATE_CNF   0x00003905

#define DEVNET_AP_WD_OFF                  0x0000
#define DEVNET_AP_WD_MIN_TIMEOUT          0x0014
#define DEVNET_APWD_MAX_TIMEOUT           0xFFFF


#define DNM_AP_CMD_START                  DEVNET_AP_CMD_START
#define DNM_AP_CMD_IO_SCAN_REQ            DEVNET_AP_CMD_IO_SCAN_REQ
#define DNM_AP_CMD_IO_SCAN_CNF            DEVNET_AP_CMD_IO_SCAN_CNF
#define DNM_AP_CMD_WATCHDOG_IND           DEVNET_AP_CMD_WATCHDOG_IND
#define DNM_AP_CMD_WATCHDOG_RSP           DEVNET_AP_CMD_WATCHDOG_RSP
#define DNM_AP_CMD_GET_LED_STATE_REQ      DEVNET_AP_CMD_GET_LED_STATE_REQ
#define DNM_AP_CMD_GET_LED_STATE_CNF      DEVNET_AP_CMD_GET_LED_STATE_CNF

#define DNM_AP_MAX_NODES                  (64)

#define DNM_AP_DNETOBJ_ALL_ATTRS         0x00               /*  NOT SUPPORTED */
#define DNM_AP_DNETOBJ_REVISION          0x01
#define DNM_AP_DNETOBJ_MACID             0x01
#define DNM_AP_DNETOBJ_BAUD              0x02
#define DNM_AP_DNETOBJ_BOI               0x03
#define DNM_AP_DNETOBJ_BUS_OFF_CNTR      0x04
#define DNM_AP_DNETOBJ_ALLOC_INFO        0x05
#define DNM_AP_DNETOBJ_QUIX_CNXN         0x0A               /*  QUICK_CONNECT */

#define DNM_AP_HW_LED_NO_LED            (0)
#define DNM_AP_HW_LED_OPERATE           (1)
#define DNM_AP_HW_LED_TEST              (2)


/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'DevNet Ap'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 DEVNET_AP_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 * 
 * eRslt = TLR_QUE_IDENTIFY(DEVNET_AP_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define DEVNET_AP_QUEUE_NAME        "QUE_DEVNET_AP"

/** @} */


/*************************************************************************************/
/* packets */

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__DEVNET_AP_PACKET)
#endif


/** @name Extended diagnostic
 *
 * The following structucture defines the extended diagnostic 
 * structure of the how it placed in the extendet diagnostic filed
 * in the dualport area 
 * @{
 */

/** extended diagnostic structure */
typedef __PACKED_PRE struct __PACKED_POST DEVNET_AP_EXT_STATUS_Ttag {
  
  DN_FAL_EXT_DIAG_T tGlobalStateFiled;
  
} DEVNET_AP_EXT_STATUS_T;


/** @} */

/******************************************************************************/
/*                     DNM_AP_PACKET_GET_LED_REQ_T Structure                    */
/******************************************************************************/
#define DNM_AP_LED_TYPE_NS                                                    1

typedef __PACKED_PRE struct __PACKED_POST DNM_AP_LED_STATE_REQ_Ttag
{
  TLR_UINT32 ulLedType;  /* MNS, NS, MS */
  //TLR_UINT32 ulLedMode;  /* ON, OFF, FLASH */
  //TLR_UINT32 ulLedColor; /* RED, GRN, OFF */
}
DNM_AP_LED_STATE_REQ_T;

#define DNM_AP_LED_STATE_REQ_SIZE (sizeof(DNM_AP_LED_STATE_REQ_T))

typedef __PACKED_PRE struct __PACKED_POST DN_AP_PACKET_GET_LED_REQ_Ttag
{
  TLR_PACKET_HEADER_T     tHead;
  DNM_AP_LED_STATE_REQ_T  tData;
}
DNM_AP_PACKET_GET_LED_REQ_T;

/******************************************************************************/
/*                       DNM_AP_PACKET_GET_LED_CNF_T Structure                  */
/******************************************************************************/
typedef __PACKED_PRE struct __PACKED_POST DNM_AP_LED_STATE_CNF_Ttag
{
  /*DNM_LED_TYPE_NS = 1 */
  TLR_UINT32 ulLedType;  /* MNS, NS, MS */

  /* DNM_LED_MODE_STATIC = 0, DNM_LED_MODE_FLASH = 1 */
  TLR_UINT32 ulLedMode;  /* ON, OFF, FLASH */

  /*DNM_LED_COLR_OFF = 0,DNM_LED_COLR_GRN = 1, DNM_LED_COLR_RED = 2 */
  TLR_UINT32 ulLedColor; /* RED, GRN, OFF */
}
DNM_AP_LED_STATE_CNF_T;

#define DNM_AP_LED_STATE_CNF_SIZE (sizeof(DNM_AP_LED_STATE_CNF_T))

typedef __PACKED_PRE struct __PACKED_POST DNM_AP_PACKET_GET_LED_CNF_Ttag
{
  TLR_PACKET_HEADER_T    tHead;

  DNM_AP_LED_STATE_CNF_T tData;
}
DNM_AP_PACKET_GET_LED_CNF_T;


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task. 
 * @{
 */

/** request data */
/** comfirmation data */

/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services,
 * which are supported by the task.
 * @{
 */

/** request */
/** comfirmation */

/** @} */


/** @name Packet Union
 *
 * The following definied unions consolidate the packets according to a service:
 *  - request and confirmation 
 *  - indication and response
 * @{
 */

/** packet union */

/** @} */


/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__DEVNET_AP_PACKET)
#endif


/*************************************************************************************/
#endif /* #ifndef __DEVNET_AP_PUBLIC_H */
